function Infobar_GetTemplateIndex(id)
	local XTemplate = XTemplates.Infobar[1][3][1]
	local idx = table.find(XTemplate,"Id", id) or false
	
	if idx then
		return idx, XTemplate[idx]
	end	
end

function Infobar_GetXWinIndex(XParent, Id)
	return table.find(XParent,"Id", Id) or false	
end

function Infobar_UpdateXWins(XParent, XWins)
	for idx,win in pairs(XWins) do 
		XParent[idx] = win
	end
end

function Infobar_AddXWins(XParent, XWins)
	for _, win in ipairs(XWins) do
		XParent[#XParent+1] = win
	end
end

function Infobar_UpdateXCategory(XInfobar, idx, XCategory)
	XInfobar[idx] = XCategory
end

-- Placement d'une catégorie entre 2 autres, avec décalage par le bas des autres
function Infobar_AddXCategoryBetween(XInfobar, idxAfter, XCategory)
	XInfobar[#XInfobar+1] = {} -- Création emplacement vide
	
	for i=#XInfobar,1,-1 do
		local XWinBuffer = XInfobar[i-1]
		XInfobar[i] = XWinBuffer
		if i == idxAfter then
			XInfobar[i] = XCategory
			break
		end
	end
end